/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.api.VWScenarioStepSettings;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.toolkit.designer.message.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMDesignerMapPane;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMDesignerWorkflowPane;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMParticipantListCellRenderer;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMRouteWeight;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMRoutingWeightTableModel;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.tables.VWStepNameListCellRenderer;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWNumericTextField;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.Document;

class VWSIMStepPropertiesTab
extends JPanel
implements DocumentListener,
ActionListener,
TableModelListener,
ItemListener,
IVWSIMPropertyChangeListener,
ListSelectionListener {
    private JComboBox m_nameComboBox = null;
    private VWNumericTextField m_durationTextField = null;
    private JComboBox m_durationComboBox = null;
    private VWTable m_weightTable = null;
    private VWSIMRoutingWeightTableModel m_weightTableModel = null;
    private JLabel m_totalWeightLabel = null;
    private JLabel m_totalWeightValueLabel = null;
    private CardLayout m_cardLayout = null;
    private JPanel m_stepDestPanel = null;
    private VWToolbarBorder m_queueBorder = null;
    private JLabel m_queueLabel = null;
    private VWToolbarBorder m_participantsBorder = null;
    private VWSortedListModel m_participantsListModel = null;
    private JList m_participantsList = null;
    private JPanel m_emptyPanel = null;
    private VWSIMDesignerWorkflowPane m_mapPane = null;
    private VWSIMPropertyData m_propertyData = null;
    private VWScenarioStepSettings m_stepSetting = null;
    private VWMapNode m_selectedStep = null;
    private String m_currentMapName = "Workflow";

    public void init(VWSIMPropertyData propertyData, VWSIMDesignerWorkflowPane mapPane) {
        this.m_propertyData = propertyData;
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        this.m_mapPane = mapPane;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridwidth = 0;
        gbCons.gridheight = 1;
        gbCons.insets = new Insets(0, 0, 0, 0);
        JPanel childPanel = this.getStepNameControlPanel();
        if (childPanel != null) {
            this.add((Component)childPanel, gbCons);
        }
        ++gbCons.gridy;
        childPanel = this.getDurationControlPanel();
        if (childPanel != null) {
            this.add((Component)childPanel, gbCons);
        }
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weighty = 0.5;
        childPanel = this.getRoutingWeightsControlPanel();
        if (childPanel != null) {
            this.add((Component)childPanel, gbCons);
        }
        ++gbCons.gridy;
        childPanel = this.getStepPropertiesPanel();
        if (childPanel != null) {
            this.add((Component)childPanel, gbCons);
        }
        this.m_cardLayout.show(this.m_stepDestPanel, VWSIMResource.s_empty);
    }

    public void reinitialize(VWMapNode stepDef, VWRouteDefinition selectedRouteDef, boolean bNotify) {
        block28: {
            try {
                VWScenarioWorkflowDefinition scenarioWfDef;
                VWWorkflowDefinition workflowDef;
                this.m_selectedStep = stepDef;
                if (this.m_selectedStep == null) {
                    this.setEnabled(false);
                    return;
                }
                if (this.m_selectedStep != this.m_nameComboBox.getSelectedItem()) {
                    this.m_nameComboBox.removeActionListener(this);
                    this.m_nameComboBox.setSelectedItem(this.m_selectedStep);
                    this.m_nameComboBox.addActionListener(this);
                }
                if ((workflowDef = this.m_propertyData.getSelectedWorkflowDefinition()) == null || (scenarioWfDef = this.m_propertyData.getScenarioDefinition().getWorkflow(workflowDef.getName())) == null) break block28;
                this.m_selectedStep = scenarioWfDef.getWorkflowDefinition().getMap(this.m_currentMapName).getStep(this.m_selectedStep.getStepId());
                this.updateStepDestinationPanel(this.m_selectedStep);
                this.m_stepSetting = scenarioWfDef.getStepSettings(this.m_currentMapName, this.m_selectedStep.getStepId());
                if (this.m_stepSetting != null) {
                    this.setEnabled(true);
                    int stepType = VWStepUtils.getStepType(this.m_selectedStep);
                    if (VWStepUtils.isSubmapStep(stepType)) {
                        this.m_durationComboBox.setEnabled(false);
                        this.m_durationTextField.setEnabled(false);
                    } else {
                        this.m_durationComboBox.setEnabled(true);
                        this.m_durationTextField.setEnabled(true);
                    }
                    if (this.m_stepSetting != null) {
                        VWScenarioTimeDuration duration = this.m_stepSetting.getDuration();
                        String unitString = VWSIMResource.s_seconds;
                        switch (duration.getUnits()) {
                            case 1: {
                                unitString = VWSIMResource.s_seconds;
                                break;
                            }
                            case 2: {
                                unitString = VWSIMResource.s_minutes;
                                break;
                            }
                            case 3: {
                                unitString = VWSIMResource.s_hours;
                                break;
                            }
                            case 4: {
                                int nDuration = Integer.parseInt(duration.getDuration()) * 24;
                                duration.setDuration(Integer.toString(nDuration));
                                duration.setUnits(3);
                                unitString = VWSIMResource.s_hours;
                                break;
                            }
                            case 5: {
                                int nDuration = Integer.parseInt(duration.getDuration()) * 24 * 5;
                                duration.setDuration(Integer.toString(nDuration));
                                duration.setUnits(3);
                                unitString = VWSIMResource.s_hours;
                                break;
                            }
                            case 6: {
                                int nDuration = Integer.parseInt(duration.getDuration()) * 24 * 5 * 4;
                                duration.setDuration(Integer.toString(nDuration));
                                duration.setUnits(3);
                                unitString = VWSIMResource.s_hours;
                                break;
                            }
                        }
                        this.m_durationTextField.getDocument().removeDocumentListener(this);
                        this.m_durationTextField.setText(duration.getDuration());
                        this.m_durationTextField.getDocument().addDocumentListener(this);
                        this.m_durationComboBox.removeActionListener(this);
                        this.m_durationComboBox.setSelectedItem(unitString);
                        this.m_durationComboBox.addActionListener(this);
                    } else {
                        this.m_durationTextField.getDocument().removeDocumentListener(this);
                        this.m_durationTextField.setText("0");
                        this.m_durationTextField.getDocument().addDocumentListener(this);
                        this.m_durationComboBox.removeActionListener(this);
                        this.m_durationComboBox.setSelectedItem(VWSIMResource.s_seconds);
                        this.m_durationComboBox.addActionListener(this);
                    }
                    VWRouteDefinition[] routeDefs = this.m_selectedStep.getNextRoutes();
                    this.m_weightTableModel.reinitialize(routeDefs, this.m_stepSetting);
                    if (routeDefs != null && routeDefs.length > 0) {
                        int nRouteIndex = 0;
                        if (routeDefs.length > 1) {
                            switch (this.m_selectedStep.getSplitType()) {
                                case 2: {
                                    this.m_totalWeightLabel.setVisible(true);
                                    this.m_totalWeightValueLabel.setVisible(true);
                                    break;
                                }
                                default: {
                                    this.m_totalWeightLabel.setVisible(false);
                                    this.m_totalWeightValueLabel.setVisible(false);
                                }
                            }
                            if (selectedRouteDef != null) {
                                for (int i = 0; i < routeDefs.length; ++i) {
                                    if (routeDefs[i] != selectedRouteDef) continue;
                                    nRouteIndex = i;
                                    break;
                                }
                            }
                        } else {
                            this.m_totalWeightLabel.setVisible(true);
                            this.m_totalWeightValueLabel.setVisible(true);
                        }
                        this.m_weightTable.clearSelection();
                        if (this.m_weightTable.getRowCount() > nRouteIndex) {
                            this.m_weightTable.setRowSelectionInterval(nRouteIndex, nRouteIndex);
                        }
                        if (bNotify) {
                            this.m_propertyData.getSelectionChangeEventNotifier().notifySelectionChange(1, new Object[]{this.m_selectedStep, routeDefs[nRouteIndex]});
                        }
                        break block28;
                    }
                    this.m_totalWeightLabel.setVisible(false);
                    this.m_totalWeightValueLabel.setVisible(false);
                    if (bNotify) {
                        this.m_mapPane.setFocusStep(stepDef.getStepId());
                    }
                    break block28;
                }
                this.setEnabled(false);
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeMap(String mapName) {
        try {
            block9: {
                try {
                    this.m_nameComboBox.removeActionListener(this);
                    this.m_nameComboBox.removeAllItems();
                    if (mapName != null) {
                        this.m_currentMapName = mapName;
                        this.m_selectedStep = null;
                        VWWorkflowDefinition wfDef = this.m_propertyData.getSelectedWorkflowDefinition();
                        if (wfDef != null) {
                            VWMapDefinition mapDef = wfDef.getMap(mapName);
                            VWMapNode[] mapNodes = mapDef.getSteps();
                            if (mapNodes != null && mapNodes.length > 0) {
                                for (int i = 0; i < mapNodes.length; ++i) {
                                    this.m_nameComboBox.addItem(mapNodes[i]);
                                }
                                VWMapNode startStep = mapDef.getStartStep();
                                this.reinitialize(startStep, null, true);
                            } else {
                                this.m_nameComboBox.addItem(VWSIMResource.s_none);
                            }
                        }
                        break block9;
                    }
                    this.setEnabled(false);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var7_9 = null;
                    this.m_nameComboBox.addActionListener(this);
                }
            }
            Object var7_8 = null;
            this.m_nameComboBox.addActionListener(this);
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.m_nameComboBox.addActionListener(this);
            throw throwable;
        }
    }

    public void setEnabled(boolean bEnable) {
        this.m_nameComboBox.setEnabled(bEnable);
        this.m_durationTextField.setEnabled(bEnable);
        this.m_durationComboBox.setEnabled(bEnable);
        this.m_weightTable.setEnabled(bEnable);
        if (!bEnable) {
            this.m_weightTableModel.reinitialize(null, null);
            this.m_cardLayout.show(this.m_stepDestPanel, VWSIMResource.s_empty);
        }
        this.m_totalWeightLabel.setEnabled(bEnable);
        this.m_totalWeightValueLabel.setEnabled(bEnable);
        this.m_participantsList.setEnabled(bEnable);
        super.setEnabled(bEnable);
    }

    public void releaseReferences() {
        this.m_nameComboBox = null;
        this.m_durationTextField = null;
        this.m_durationComboBox = null;
        this.m_weightTable = null;
        this.m_weightTableModel = null;
        this.m_totalWeightLabel = null;
        this.m_totalWeightValueLabel = null;
        this.m_participantsList = null;
    }

    public void changedUpdate(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.m_durationTextField.getDocument()) {
            this.updateDurationTextField();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_durationComboBox) {
            this.performDurationComboBoxAction();
        } else if (src == this.m_nameComboBox) {
            this.reinitialize((VWMapNode)this.m_nameComboBox.getSelectedItem(), null, true);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case 0: {
                this.onUpdateTable();
                break;
            }
            case -1: 
            case 1: {
                int row = event.getLastRow() - 1;
                if (row < 0) {
                    row = 0;
                }
                if (row == this.m_weightTable.getSelectedRow()) {
                    this.m_weightTable.clearSelection();
                }
                if (row < 0 || this.m_weightTableModel.getRowCount() <= 0) break;
                this.m_weightTable.setRowSelectionInterval(row, row);
                break;
            }
        }
    }

    public void itemStateChanged(ItemEvent event) {
        try {
            this.m_weightTable.stopEditing();
            Object source = event.getItem();
            if (source != null && source instanceof VWSIMDesignerMapPane) {
                VWSIMDesignerMapPane mapPane = (VWSIMDesignerMapPane)source;
                Object[] selectedObjects = mapPane.getSelectedObjects();
                if (selectedObjects != null && selectedObjects.length > 0) {
                    VWMapNode selectedStep = null;
                    VWRouteDefinition routeDef = null;
                    if (selectedObjects[0] != null && selectedObjects[0] instanceof VWMapNode) {
                        selectedStep = (VWMapNode)selectedObjects[0];
                    }
                    if (selectedObjects.length > 1 && selectedObjects[1] != null && selectedObjects[1] instanceof VWRouteDefinition) {
                        routeDef = (VWRouteDefinition)selectedObjects[1];
                    }
                    this.reinitialize(selectedStep, routeDef, false);
                } else {
                    this.reinitialize(null, null, false);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 103: {
                this.m_weightTable.stopEditing();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            VWRouteDefinition routeDef;
            VWSIMRouteWeight routeWeight;
            int nRowIndex;
            if (!event.getValueIsAdjusting() && (nRowIndex = this.m_weightTable.getSelectedRow()) != -1 && (routeWeight = this.m_weightTableModel.getItemAt(nRowIndex)) != null && this.m_selectedStep != null && (routeDef = this.m_selectedStep.getRoute(routeWeight.getID())) != null) {
                this.m_propertyData.getSelectionChangeEventNotifier().notifySelectionChange(1, new Object[]{this.m_selectedStep, routeDef});
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getStepNameControlPanel() {
        VWToolbarBorder stepNameBorder = new VWToolbarBorder(VWSIMResource.s_stepName);
        JPanel stepNamePanel = stepNameBorder.getClientPanel();
        stepNamePanel.setLayout(new BorderLayout());
        this.m_nameComboBox = new JComboBox();
        this.m_nameComboBox.setRenderer(new VWStepNameListCellRenderer());
        stepNamePanel.add(this.m_nameComboBox);
        return stepNameBorder;
    }

    private JPanel getDurationControlPanel() {
        VWToolbarBorder durationBorder = new VWToolbarBorder(VWSIMResource.s_duration);
        JPanel durationPanel = durationBorder.getClientPanel();
        durationPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridwidth = 1;
        gbCons.gridheight = 1;
        gbCons.insets = new Insets(2, 0, 0, 0);
        this.m_durationTextField = new VWNumericTextField(6, 0, false);
        this.m_durationTextField.getDocument().addDocumentListener(this);
        durationPanel.add((Component)this.m_durationTextField, gbCons);
        ++gbCons.gridx;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(0, 5, 0, 0);
        this.m_durationComboBox = new JComboBox();
        this.m_durationComboBox.addItem(VWSIMResource.s_seconds);
        this.m_durationComboBox.addItem(VWSIMResource.s_minutes);
        this.m_durationComboBox.addItem(VWSIMResource.s_hours);
        this.m_durationComboBox.addActionListener(this);
        this.m_durationComboBox.setRenderer(new VWLabelListCellRenderer());
        durationPanel.add((Component)this.m_durationComboBox, gbCons);
        return durationBorder;
    }

    private JPanel getRoutingWeightsControlPanel() {
        VWToolbarBorder routeWeightBorder = new VWToolbarBorder(VWSIMResource.s_routeWeight);
        JPanel routeWeightPanel = routeWeightBorder.getClientPanel();
        routeWeightPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.anchor = 23;
        gbCons.gridwidth = 0;
        gbCons.gridheight = 1;
        this.m_weightTableModel = new VWSIMRoutingWeightTableModel(this.m_propertyData);
        this.m_weightTableModel.addTableModelListener(this);
        this.m_weightTable = new VWTable(this.m_weightTableModel);
        this.m_weightTable.getSelectionModel().addListSelectionListener(this);
        this.m_weightTable.getSelectionModel().setSelectionMode(0);
        this.m_weightTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_weightTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        routeWeightPanel.add((Component)new JScrollPane(this.m_weightTable), gbCons);
        ++gbCons.gridy;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 22;
        gbCons.gridwidth = 1;
        this.m_totalWeightLabel = new JLabel(VWSIMResource.s_totalWeight);
        routeWeightPanel.add((Component)this.m_totalWeightLabel, gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.anchor = 21;
        gbCons.gridwidth = 0;
        this.m_totalWeightValueLabel = new JLabel("0%");
        routeWeightPanel.add((Component)this.m_totalWeightValueLabel, gbCons);
        return routeWeightBorder;
    }

    private JPanel getStepPropertiesPanel() {
        this.m_queueBorder = new VWToolbarBorder(VWSIMResource.s_workQueue);
        JPanel queuePanel = this.m_queueBorder.getClientPanel();
        queuePanel.setLayout(new BorderLayout());
        this.m_queueLabel = new JLabel();
        queuePanel.add((Component)this.m_queueLabel, "First");
        this.m_participantsBorder = new VWToolbarBorder(VWSIMResource.s_participants);
        JPanel participantsPanel = this.m_participantsBorder.getClientPanel();
        participantsPanel.setLayout(new BorderLayout());
        this.m_participantsListModel = new VWSortedListModel();
        this.m_participantsList = new JList(this.m_participantsListModel);
        this.m_participantsList.setCellRenderer(new VWSIMParticipantListCellRenderer());
        participantsPanel.add((Component)new JScrollPane(this.m_participantsList), "Center");
        this.m_emptyPanel = new JPanel();
        this.m_cardLayout = new CardLayout();
        this.m_stepDestPanel = new JPanel(this.m_cardLayout);
        this.m_stepDestPanel.add((Component)this.m_queueBorder, VWSIMResource.s_workQueue);
        this.m_stepDestPanel.add((Component)this.m_participantsBorder, VWSIMResource.s_participants);
        this.m_stepDestPanel.add((Component)this.m_emptyPanel, VWSIMResource.s_empty);
        return this.m_stepDestPanel;
    }

    private void performDurationComboBoxAction() {
        int nUnit = 1;
        String unitString = (String)this.m_durationComboBox.getSelectedItem();
        if (VWStringUtils.compare(unitString, VWSIMResource.s_seconds) == 0) {
            nUnit = 1;
        } else if (VWStringUtils.compare(unitString, VWSIMResource.s_minutes) == 0) {
            nUnit = 2;
        } else if (VWStringUtils.compare(unitString, VWSIMResource.s_hours) == 0) {
            nUnit = 3;
        }
        try {
            this.m_stepSetting.getDuration().setUnits(nUnit);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateStepDestinationPanel(VWMapNode mapNode) {
        if (mapNode != null) {
            int stepType = VWStepUtils.getStepType(mapNode);
            if (stepType == 0 || VWStepUtils.isSubmapStep(stepType) || VWStepUtils.isSystemStep(stepType) || VWStepUtils.isComponentStep(stepType)) {
                this.m_cardLayout.show(this.m_stepDestPanel, VWSIMResource.s_empty);
            } else {
                VWStepDefinition stepDef = (VWStepDefinition)mapNode;
                String queueName = stepDef.getQueueName();
                if (queueName != null && VWStringUtils.compare(queueName, "Inbox") != 0) {
                    this.m_queueLabel.setText(queueName);
                    this.m_cardLayout.show(this.m_stepDestPanel, VWSIMResource.s_workQueue);
                } else {
                    VWSortedListModel listModel = (VWSortedListModel)this.m_participantsList.getModel();
                    listModel.removeAllElements();
                    VWParticipant[] participants = stepDef.getParticipants();
                    if (participants != null) {
                        for (int i = 0; i < participants.length; ++i) {
                            String name = participants[i].getParticipantName();
                            if (name.charAt(0) == '\"') {
                                name = name.substring(1, name.length() - 1);
                            }
                            if (!this.isWorkflowGroup(name)) continue;
                            participants[i].setParticipantName(name);
                        }
                        VWParticipantItem[] items = null;
                        try {
                            items = VWDefaultSessionProxy.getQuotedFullParticipantItems(participants, true);
                        }
                        catch (Exception ex) {
                            items = VWDefaultSessionProxy.getParticipantItemsUsingParticipants(participants, true);
                        }
                        if (items != null && items.length > 0) {
                            for (int i = 0; i < items.length; ++i) {
                                listModel.addElement(items[i]);
                            }
                        } else if (participants != null && participants.length > 0) {
                            for (int i = 0; i < participants.length; ++i) {
                                listModel.addElement(participants[i]);
                            }
                        }
                    }
                    this.m_cardLayout.show(this.m_stepDestPanel, VWSIMResource.s_participants);
                }
            }
        }
    }

    private boolean isWorkflowGroup(String participantName) {
        if (VWStringUtils.compare(participantName, "F_Originator") == 0) {
            return true;
        }
        VWWorkflowDefinition workflowDef = this.m_propertyData.getSelectedWorkflowDefinition();
        if (workflowDef != null) {
            try {
                VWFieldDefinition fieldDef = workflowDef.getField(participantName);
                return fieldDef.getFieldType() == 64;
            }
            catch (VWException vWException) {
                // empty catch block
            }
        }
        return false;
    }

    private void updateDurationTextField() {
        try {
            String durationString = this.m_durationTextField.getText();
            this.m_stepSetting.getDuration().setDuration(durationString);
            this.m_propertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateTable() {
        int totalWeight = this.m_weightTableModel.getTotalWeight();
        this.m_totalWeightValueLabel.setText(totalWeight + "%");
        if (totalWeight > 100) {
            ImageIcon icon = VWSIMImageLoader.createImageIcon("error.gif");
            this.m_totalWeightValueLabel.setIcon(icon);
            this.m_totalWeightValueLabel.setHorizontalTextPosition(10);
        } else {
            this.m_totalWeightValueLabel.setIcon(null);
        }
    }
}

